#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const double eps = 1e-10;
const int N = 111;
bool is_line[N][N], is_line_factor[N][N], is_point[N][N], is_point_factor[N][N], is_number[N][N];
int number[N][N];
char s[N];

struct pt {
	double x, y;
	pt(double x, double y): x(x), y(y) {}
	pt() {}
} point[N][N];

struct tline {
	double a, b, c;
} line[N][N];

double det2(double a, double b, double c, double d) {
	return a * d - b * c;
}

double smul(const pt& p, const pt& q) {
	return p.x * q.x + p.y * q.y;
}

pt cross(const tline& l1, const tline& l2) {
	double d = det2(l1.a, l1.b, l2.a, l2.b);
	assert(fabs(d) > eps);
	pt p = pt(det2(-l1.c, l1.b, -l2.c, l2.b) / d, det2(l1.a, -l1.c, l2.a, -l2.c) / d);
	assert(fabs(l1.a * p.x + l1.b * p.y + l1.c) < eps);
	assert(fabs(l2.a * p.x + l2.b * p.y + l2.c) < eps);
	return p;
}

pt reflect(const tline& l, const pt& p) {
	double d = l.a * p.x + l.b * p.y + l.c;
	return pt(p.x - 2 * d * l.a, p.y - 2 * d * l.b);
}

tline make_line(const pt& p1, const pt& p2) {
	tline l;
	l.a = p1.y - p2.y;
	l.b = p2.x - p1.x;
	l.c = - l.a * p1.x - l.b * p1.y;
	double s = sqrt(l.a * l.a + l.b * l.b);
	l.a /= s, l.b /= s, l.c /= s;
	return l;
}

int main() {
	assert(freopen("input.txt", "r", stdin));
	assert(freopen("output.txt", "w", stdout));
	while ((scanf("%s", s) == 1) && (strcmp(s, "#") != 0)) {
		int n = strlen(s);
		for (int l = n - 1; l >= 0; --l)
			for (int r = l; r < n; ++r) {
				is_point[l][r] = is_number[l][r] = is_line[l][r] = is_line_factor[l][r] = is_point_factor[l][r] = false;
				if ((s[l] == '-') || isdigit(s[l])) {
					int k = l, sign = 1, value = 0;
					if (s[k] == '-') k++, sign = -1;
					while ((k <= r) && isdigit(s[k]))
						value = value * 10 + (s[k++] - '0');
					if ((k == r + 1) && ((sign == 1) || (r - l + 1 > 1))) {
						is_number[l][r] = true;
						number[l][r] = sign * value;
					}
				}
				for (int k = l + 1; k < r; ++k)
					if ((s[l] == '(') && (s[r] == ')') && (s[k] == ',') && is_number[l + 1][k - 1] && is_number[k + 1][r - 1]) {
						is_point_factor[l][r] = true;
						point[l][r] = pt(number[l + 1][k - 1], number[k + 1][r - 1]);
					}
				if (is_point[l + 1][r - 1]) {
					is_point_factor[l][r] = true;
					point[l][r] = point[l + 1][r - 1];
				}
				if (is_point_factor[l][r])
					is_point[l][r] = true;
				for (int k = l + 1; k < r; ++k) {
					if (s[k] != '@') continue;
					if (is_line[l][k - 1] && is_line_factor[k + 1][r]) {
						is_point[l][r] = true;
						point[l][r] = cross(line[l][k - 1], line[k + 1][r]);
					}
					if (is_line[l][k - 1] && is_point_factor[k + 1][r]) {
						is_point[l][r] = true;
						point[l][r] = reflect(line[l][k - 1], point[k + 1][r]);
					}
					if (is_point[l][k - 1] && is_line_factor[k + 1][r]) {
						is_point[l][r] = true;
						point[l][r] = reflect(line[k + 1][r], point[l][k - 1]);
					}
				}
				if ((s[l] == '(') && (s[r] == ')') && is_line[l + 1][r - 1]) {
					is_line_factor[l][r] = true;
					line[l][r] = line[l + 1][r - 1];
				}
				if (is_line_factor[l][r])
					is_line[l][r] = true;
				for (int k = l + 1; k < r; ++k) {
					if (s[k] != '@') continue;
					if (is_point[l][k - 1] && is_point_factor[k + 1][r]) {
						is_line[l][r] = true;
						line[l][r] = make_line(point[l][k - 1], point[k + 1][r]);
					}
				}
			}
		assert(is_point[0][n - 1]);
		printf("%.10lf %.10lf\n", point[0][n - 1].x, point[0][n - 1].y);
	}
	return 0;
}